@extends('layouts.admin')

@section('title', 'Create Product Type')
@section('content-header', 'Modify Product Type')

@section('content')

<div class="card">
    <div class="card-body">
	<!-- Log on to codeastro.com for more projects -->
    <form style="width:50%;margin-left:25%;" action="{{route('admin.producttype.update', $producttype->id)}}" method="POST" enctype='multipart/form-data' class="needs-validation" novalidate>
        @csrf
        @method("put")    
        <div class="form-group">
            <label for="duration">Name:</label>
            <input type="text" class="form-control" value="{{$producttype->name}}" id="name" placeholder="Management Name" name="name" required>
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div> 
        <div class="form-group">
            <label for="duration">Active:</label>
            <input type="checkbox" {{$producttype->active ==1 ? "checked":""}} value="1" id="active" name="active">
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>
        
        <button type="submit" class="btn btn-primary"><i class="fa fa-edit"></i>Modify</button>
    </form>
    
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
<script>
    $(document).ready(function () {
        bsCustomFileInput.init();
    });
</script>
@endsection