@extends('layouts.admin')

@section('title', 'Create Product')
@section('content-header', 'Create Product')

@section('content')

<div class="card">
    <div class="card-body">
	<!-- Log on to codeastro.com for more projects -->
    <form style="width:50%;margin-left:25%;" action="{{route('admin.product.store')}}" enctype='multipart/form-data' method="POST" class="needs-validation" novalidate>
        @csrf  
        <div class="form-group">
            <label for="status">Category*:</label>
            <select class="form-control" id="category_id"  name="category_id" required>
                <option value="">Select Category</option>
                @foreach ( $categories as $category )
                    <option value="{{$category->id}}">{{$category->name}}</option>                                        
                @endforeach
            </select>
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>     
        <div class="form-group">
            <label for="status">Product Type *:</label>
            <select class="form-control" id="producttype_id"  name="producttype_id" required>
                <option value="">Select Product Type</option>
                @foreach ( $producttypes as $producttype )
                    <option value="{{$producttype->id}}">{{$producttype->name}}</option>                                        
                @endforeach
            </select>
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>     
        <div class="form-group">
            <label for="duration">Name:</label>
            <input type="text" class="form-control" id="name" placeholder="Product Name" name="name" required>
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>       
        <div class="form-group">
            <label for="duration">Image:</label>
            <input type="file" class="form-control" id="formpic" accept="image/*" name="formpic" required>
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>  
        <div class="form-group">
            <label for="home">Show On Home Page:</label>
            <input type="checkbox" checked value="1" id="home" name="home">
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div> 
         
        <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i>Submit</button>
    </form>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
<script>
    $(document).ready(function () {
        bsCustomFileInput.init();
    });
</script>
@endsection
