@extends('layouts.admin')

@section('title', 'Create Management')
@section('content-header', 'Modify Management')

@section('content')

<div class="card">
    <div class="card-body">
	<!-- Log on to codeastro.com for more projects -->
    <form style="width:50%;margin-left:25%;" action="{{route('admin.management.update', $management->id)}}" method="POST" enctype='multipart/form-data' class="needs-validation" novalidate>
        @csrf
        @method("put") 
        <div class="form-group">
            <label for="duration">Name:</label>
            <input type="text" class="form-control" value="{{$management->name}}" id="name" placeholder="Management Name" name="name" required>
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>
        <div class="form-group">
            <label for="duration">Image:</label>
            <input type="file" class="form-control" id="formfile" placeholder="select image" accept="image/*" name="formfile">
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>
        <div class="form-group">
            <label for="duration">postion:</label>
            <input type="text" class="form-control" value="{{$management->post}}" id="post" placeholder="Post Name" name="post" >
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>
        <div class="form-group">
            <label for="duration">facebook:</label>
            <input type="text" class="form-control" value="{{$management->facebook}}" id="facebook" placeholder="Facebook Name" name="facebook">
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div> 
        <div class="form-group">
            <label for="duration">Twitter:</label>
            <input type="text" class="form-control" value="{{$management->twitter}}" id="twitter" placeholder="twitter" name="twitter">
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>
        <div class="form-group">
            <label for="duration">Instagram:</label>
            <input type="text" class="form-control" value="{{$management->instagram}}" id="instagram" placeholder="Instagram" name="instagram">
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>
        <div class="form-group">
            <label for="duration">Linkedin:</label>
            <input type="text" class="form-control" value="{{$management->linkedin}}" id="linkedin" placeholder="linkedin name" name="linkedin">
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>
        <div class="form-group">
            <label for="duration">Active:</label>
            <input type="checkbox" {{$management->active == 1 ? "checked":""}} value="1" id="active" name="active">
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div> 
        
        <button type="submit" class="btn btn-primary"><i class="fa fa-edit"></i>Modify</button>
    </form>
    
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
<script>
    $(document).ready(function () {
        bsCustomFileInput.init();
    });
</script>
@endsection