<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>@yield('title', config('app.name'))</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- overlayScrollbars --> 
	<!-- Log on to codeastro.com for more projects -->

    <link rel="stylesheet" src="{{asset('css/bootstrap.min.css')}}">
    <!-- overlayScrollbars -->
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('fonts/app.css') }}">
    
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    {{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"> --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    @yield('css')
    <style>
        .ck-editor__editable_inline{
            height: 150px;
        }
        #scrollToTop {
            position: fixed; 
            left: 90vw;
            top: 90vh;
            background-color: black; /* Button background color */
            color: #fff; /* Text color */
            border: none;
            border-radius: 50%; /* Make button circular */
            width: 50px; /* Button width */
            height: 50px; /* Button height */
            cursor: pointer;
            transition: background-color 0.3s; /* Smooth transition */
        }

        #scrollToTop:hover {
            background-color: #0056b3; /* Change background color on hover */
        }

        #scrollToTop span {
            position: absolute;
            top: 35%;
            left: 33%;
            transform: translate(-25%, -25%); /* Center the span */
            width: 20px;
            height: 20px;
            border-top: 2px solid #fff; /* Arrow top */
            border-left: 2px solid #fff; /* Arrow left */
            transform: rotate(40deg); /* Rotate the arrow */
        }
    </style>
   
</head>

<body class="hold-transition sidebar-mini">
    <!-- Site wrapper -->
    <div class="wrapper">

        @include('layouts.partials.navbar')
        @include('layouts.partials.sidebar')
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-10">
                            <h1>@yield('content-header')</h1>
                        </div>
                        <div class="col-sm-6 text-right">
                            @yield('content-actions')
                        </div><!-- /.col -->
                    </div>
                </div> 
            </section> 

            <!-- Main content -->
            <section class="content">
                @include('layouts.partials.alert.success')
                @include('layouts.partials.alert.error')
                <button id="scrollToTop" onclick="scrollToTop()">
                    <span></span>
                </button>
                <!-- Topbar Search -->
                @if(!empty($enableSearch) && $enableSearch =="yes")
                    <form class="col-12 py-2">
                        <div class="input-group">
                            <input type="text" id="searchField" style="width:100% !important;" class="form-control" 
                            placeholder="Search for..." value="" onkeyup="searchForData(event)"
                                aria-label="Search" aria-describedby="basic-addon2">
                            <div class="input-group-append" style="display:none;">
                                <button class="btn btn-primary" type="button">
                                    <i class="fas fa-search fa-sm"></i>
                                </button>
                            </div>
                        </div>
                    </form> 
                @elseif(!empty($enableSearch) && $enableSearch =="yes-member")
                    <form class="col-12 py-2">
                        <div class="input-group">
                            <input type="text" id="searchField" style="width:100% !important;" class="form-control" 
                            placeholder="Search for..." value="" onkeyup="searchForDataInMember(event)"
                                aria-label="Search" aria-describedby="basic-addon2">
                            <div class="input-group-append" style="display:none;">
                                <button class="btn btn-primary" type="button">
                                    <i class="fas fa-search fa-sm"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                @endif

                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800"></h1>
                        @if(!empty($downloadRoute) && strlen($downloadRoute) > 1)
                            <a href="{{$downloadRoute}}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                                class="fas fa-download fa-sm text-white-50"></i> {{ $downloadText ?? "Download"}}</a>
                        @endif
                    
                        @if(!empty($memberDownloadRoute) && strlen($memberDownloadRoute) > 1)
                            <form method="get" action="{{$memberDownloadRoute}}">
                                <select name="ismember">
                                    <option>*</option> 
                                    <option value="1">Members</option>
                                    <option value="0">None Members</option> 
                                </select>
                                <select name="kindred">
                                    <option>*</option> 
                                    @foreach($kindreds as $kindred)
                                        <option value="{{$kindred->id}}">{{$kindred->name}}</option> 
                                    @endforeach 
                                </select>
                                <button type="submit" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                                    class="fas fa-download fa-sm text-white-50"></i> {{ $downloadText ?? "Download"}}
                                </button>
                            </form>
                            
                        @endif
                    </div>
                    

                @yield('content')
            </section>

        </div>
        <!-- /.content-wrapper -->

        @include('layouts.partials.footer')

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            
        </aside> 
    </div>  

    <script src="{{ asset('js/app.js') }}"></script>
    <script src="{{ asset('js/search.js') }}"></script>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.3/js/bootstrap.min.js"></script>
    <script src="{{ asset('js/bootstrap.min.js') }}"></script> 
    <script>
        function scrollToTop() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth' // Smooth scrolling animation
            });
        }    
    </script>
    @yield('js')
</body>

</html>
