<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Contact - Vin-Iyke Multiconnection LTD Website</title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="{{asset('assets/img/favicon.png')}}" rel="icon">
  <link href="{{asset('assets/img/apple-touch-icon.png')}}" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,300;1,400;1,500;1,600;1,700;1,800&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="{{asset('assets/vendor/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet">
  <link href="{{asset('assets/vendor/bootstrap-icons/bootstrap-icons.css')}}" rel="stylesheet">
  <link href="{{asset('assets/vendor/aos/aos.css')}}" rel="stylesheet">
  <link href="{{asset('assets/vendor/glightbox/css/glightbox.min.css')}}" rel="stylesheet">
  <link href="{{asset('assets/vendor/swiper/swiper-bundle.min.css')}}" rel="stylesheet">

  <!-- Main CSS File -->
  <link href="{{asset('assets/css/main.css')}}" rel="stylesheet">

  
</head>

<body class="contact-page">

  <header id="header" class="header d-flex align-items-center fixed-top">
    <div class="container-fluid container-xl position-relative d-flex align-items-center justify-content-between">

      <a href="{{route('index')}}" class="logo d-flex align-items-center">
        <!-- Uncomment the line below if you also wish to use an image logo -->
        <img src="{{asset('assets/img/viniykelogo.jpg')}}" alt="">
        <!-- <h1 class="sitename">Vin-Iyke</h1> <span>.</span> -->
      </a>
      @php
        $index = request()->routeIs('index') ? 'active' : '';
        $about = request()->routeIs('about') ? 'active' : '';
        $gallery = request()->routeIs('gallery') ? 'active' : '';
        $contact = request()->routeIs('contact') ? 'active' : '';
        $productActive = $index=="" && $about=="" && $gallery=="" && $contact=="" ? "active":"";
      @endphp
      <nav id="navmenu" class="navmenu">
        <ul>
            <li>
                <a href="{{ route('index') }}" class="{{ request()->routeIs('index') ? 'active' : '' }}">Home</a>
            </li>
            <li>
                <a href="{{ route('about') }}" class="{{ request()->routeIs('about') ? 'active' : '' }}">About</a>
            </li>
            <li class="dropdown">
                <a class="{{$productActive}}" href="#"><span>Product</span><i class="bi bi-chevron-down"></i></a>
                <ul>
                    @foreach ($categories as $category)
                    <li>
                        <a href="{{ route('get.product', $category->slug) }}" 
                           class="{{ request()->routeIs('get.product') && request()->segment(2) === $category->slug ? 'active' : '' }}">
                            {{ $category->name }}
                        </a>
                    </li>
                    @endforeach
                </ul>
            </li>
            <li>
                <a href="{{ route('gallery') }}" class="{{ request()->routeIs('gallery') ? 'active' : '' }}">Gallery</a>
            </li>
            <li>
                <a href="{{ route('contact') }}" class="{{ request()->routeIs('contact') ? 'active' : '' }}">Contact</a>
            </li>
        </ul>
        <i class="mobile-nav-toggle d-xl-none bi bi-list"></i>
      </nav>
    

    </div>
  </header>

  <main class="main">                
    @yield('body')

    
  </main>

  <footer id="footer" class="footer">

    <div class="container footer-top">
      <div class="row gy-4">
        <div class="col-lg-4 col-md-6 footer-about">
          <a href="{{route('index')}}" class="logo d-flex align-items-center">
            <img src="{{asset('assets/img/viniykelogo.jpg')}}" alt="">
            <!-- <span class="sitename">Vin-Iyke</span> -->
          </a>
          <div class="footer-contact pt-3">
            <p></p>
            <p>10 Odiche Street, Starco Filling Station, Doyin Coker,</p>
            <p>Block A, Shop 1&2, Peace Plaza, Ist Floor, Agric Market, Coker, Lagos, Nigeria</p>
            <p class="mt-3"><strong>Phone:</strong> <span>+234 803 080 7088</span></p>
            <p><strong>Email:</strong> <span>info@vin-iyke.com</span></p>
          </div>
          <div class="social-links d-flex mt-4">
            <a href=""><i class="bi bi-twitter-x"></i></a>
            <a href="https://www.facebook.com/profile.php?id=61556919699276&mibextid=ZbWKwL"><i class="bi bi-facebook"></i></a>
            <a href="https://www.instagram.com/vin_iyke_ceramicsandtiles?igsh=MW5pcGZvd2diazN6aQ=="><i class="bi bi-instagram"></i></a>
            <a href=""><i class="bi bi-linkedin"></i></a>
          </div>
        </div>

        <div class="col-lg-2 col-md-3 footer-links">
          <h4>Useful Links</h4>
          <ul>
            <li><a href="{{route('index')}}">Home</a></li>
            <li><a href="{{route('about')}}">About us</a></li>
            {{-- <li><a href="{{route('allProducts')}}">Products</a></li> --}}
            <li><a href="{{route('gallery')}}">Gallery</a></li>
            <li><a href="{{route('contact')}}">Contact</a></li>
          </ul>
        </div>

        <div class="col-lg-2 col-md-3 footer-links">
          <h4>Our Products</h4>
          <ul>
            @foreach ($categories as $category)
              <li><a href="{{route('get.product', $category->slug)}}">{{$category->name}}</a></li>                
            @endforeach
          </ul>
        </div>

        <div class="col-lg-2 col-md-3 footer-links">
          <h4>Our Quality Tiles</h4>
          <ul>
            @foreach ($tiles as $tile)
              <li><a href="{{route('all.products', $tile->slug)}}">{{$tile->name}}</a></li>                
            @endforeach 
          </ul>
        </div>

        <div class="col-lg-2 col-md-3 footer-links">
          <h4>Sanitary Wares</h4>
          <ul> 
            @foreach ($wares as $ware)
              <li><a href="{{route('all.products', $ware->slug)}}">{{$ware->name}}</a></li>                
            @endforeach   
          </ul>
        </div>

        <!-- <div class="col-lg-2 col-md-3 footer-links">
          <h4>Profile</h4>
          <ul>
            <li><a href="#">Hanging WC</a></li>
            <li><a href="#">Close Couple</a></li>
            <li><a href="#">Jacussi</a></li>
            <li><a href="#">Water Heater</a></li>
            <li><a href="#">Water Mixer</a></li>
            <li><a href="#">Tap, Shower</a></li>
             <li><a href="#"></a></li> -->
          </ul>
        </div>

      </div>
    </div>

    <div class="container copyright text-center mt-4">
      <p>© <span>Copyright <strong><span>Vin-Iyke Multiconnection LTD</span></strong>. All Rights Reserved</span></p>
      <div class="credits">
        <!-- All the links in the footer should remain intact. -->
        <!-- You can delete the links only if you've purchased the pro version. -->
        <!-- Licensing information: https://bootstrapmade.com/license/ -->
        <!-- Purchase the pro version with working PHP/AJAX contact form: [buy-url] -->
        Designed by <a href="https://comfix.com/">Comfix Technologies and Services (+234-803-744-1879)</a>
      </div>
    </div>

  </footer>

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Preloader -->
  <div id="preloader"></div>

  <!-- Vendor JS Files -->
  <script src="{{asset('assets/vendor/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
  <script src="{{asset('assets/vendor/php-email-form/validate.js')}}"></script>
  <script src="{{asset('assets/vendor/aos/aos.js')}}"></script>
  <script src="{{asset('assets/vendor/glightbox/js/glightbox.min.js')}}"></script>
  <script src="{{asset('assets/vendor/imagesloaded/imagesloaded.pkgd.min.js')}}"></script>
  <script src="{{asset('assets/vendor/isotope-layout/isotope.pkgd.min.js')}}"></script>
  <script src="{{asset('assets/vendor/swiper/swiper-bundle.min.js')}}"></script>
  <script src="{{asset('assets/vendor/purecounter/purecounter_vanilla.js')}}"></script>

  <!-- Main JS File -->
  <script src="{{asset('assets/js/main.js')}}"></script>
  <script>
    function href(link){
      alert(link)
      window.location.href = link
    }
  </script>
</body>

</html>