@extends("frontend.layout")
@section("body")
  <main class="main">

    <!-- Page Title -->
    <div class="page-title" data-aos="fade" style="background-image: url({{asset('assets/img/coverpage/contactmain.jpeg')}});">
      <div class="container position-relative">
        <h1>{{$category->name}}</h1>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="{{route('index')}}">Home</a></li>
            <li class="current">{{$category->name}}</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

    <!-- Projects Section -->
    <section id="projects" class="projects section">

      <div class="container">

        <div class="isotope-layout" data-default-filter="*" data-layout="masonry" data-sort="original-order">

          <ul class="portfolio-filters isotope-filters" data-aos="fade-up" data-aos-delay="100">
            <li data-filter="*" class="filter-active">All</li>
            @foreach ($category_producttypes as $category_producttype)
              <li data-filter=".{{$category_producttype->slug}}">{{$category_producttype->name}}</li>                
            @endforeach 
            <!-- <li data-filter=".filter-design">Design</li> -->
          </ul><!-- End Portfolio Filters -->

          <div class="row gy-4 isotope-container" data-aos="fade-up" data-aos-delay="200">
            @foreach($products as $product)
              <div class="col-lg-4 col-md-6 portfolio-item isotope-item {{$product->slug}}">
                <div class="portfolio-content h-100">
                  <img src="{{asset($product->pic)}}" style="height: 480px; width:100%;" class="img-fluid" alt="">
                  <div class="portfolio-info">
                    <h4>{{$product->name}}</h4>
                    <p>{{$product->name}}</p>
                    <a href="{{asset($product->pic)}}" title="{{$product->name}}" data-gallery="portfolio-gallery-plastic" class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>                    
                  </div>
                </div>
              </div><!-- End Portfolio Item -->
            @endforeach
          </div><!-- End Portfolio Container -->

        </div>

      </div>

    </section><!-- /Projects Section -->

  </main>
@endsection