<?php
namespace App\Service;

use App\Models\Category;
use App\Models\Product;
use App\Models\Producttype;
use App\Setup\Doors\Doors;
use App\Setup\Led\Led;
use App\Setup\Mirror\Mirror;
use App\Setup\Profile\Profile;
use App\Setup\Tiles\Bricks;
use App\Setup\Tiles\Deco;
use App\Setup\Tiles\Floors;
use App\Setup\Tiles\Golden;
use App\Setup\Tiles\Newbrick;
use App\Setup\Tiles\Swimmingpool;
use App\Setup\Tiles\Wall;
use App\Setup\Tiles\Wooden;
use App\Setup\Ware\Basin;
use App\Setup\Ware\Heater;
use App\Setup\Ware\Jacuzi;
use App\Setup\Ware\Shower;
use App\Setup\Ware\Tap;
use App\Setup\Ware\Voss;
use App\Setup\Ware\Wc;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SetupService
{
    public static function setProduct($arrs){ 
        foreach ($arrs as $arr) {
            $categoryName = $arr["category"];
            $producttypeName = $arr["producttype"];
            $name = $arr["name"];
            $slug = Str::slug($arr["name"]);
            $pic = $arr["pic"];
            if(strpos($pic, ".mp4"))continue;

            self::createProduct($categoryName, $producttypeName, $name, $slug, $pic);
        }
    }

    public static function createProduct($categoryName, $producttypeName, $name, $slug, $pic)
    {
        $active = 1;
        $cateSlug = Str::slug($categoryName);  
        $cate = Category::where("slug", $cateSlug)->first();
        if(empty($cate)){ 
            $cate = Category::create(["name"=>$categoryName, "slug"=>$cateSlug, "active"=>1]);
        }

        $pTypeSlug = Str::slug($producttypeName); 
        $pType = Producttype::where("slug", $pTypeSlug)->first();
        if(empty($pType)){ 
            $pType = Producttype::create(["category_id"=> $cate->id, "name"=>$producttypeName, "slug"=>$pTypeSlug, "active"=>1]);
        }

        $category_id = $cate->id;
        $producttype_id = $pType->id;


        $exists = Product::where('slug', $slug)->exists();

        if (!$exists) {
            // Insert the new record
            // dd([
            //     'category_id' => $category_id,
            //     'producttype_id' => $producttype_id,
            //     'name' => $name,
            //     'slug' => $slug,
            //     'pic' => $pic,
            //     'home' => 0,
            //     'active' => $active,
            // ]);
            Product::create([
                'category_id' => $category_id,
                'producttype_id' => $producttype_id,
                'name' => $name,
                'slug' => $slug,
                'pic' => $pic,
                'home' => 0,
                'active' => $active,
            ]);

            return 'Product inserted successfully.';
        }

        return 'Product with the same slug already exists.';
    }

    public static function homeProducts(){
        $categories = Category::get("id");
        foreach ($categories as $category) {
            $products = Product::where("category_id", $category->id)->orderBy("id", "desc")->limit(3)->get(['id']);
            foreach ($products as $product) {
                Product::where("id", $product->id)->update(["home"=>1]);
            }
        }
        
    }

    public static function setup(){
        self::setProduct(Doors::$data);
        self::setProduct(Led::$data); 
        self::setProduct(Mirror::$data); 
        self::setProduct(Profile::$data); 
        self::setProduct(Bricks::$data); 
        self::setProduct(Deco::$data); 
        self::setProduct(Floors::$data); 
        self::setProduct(Golden::$data); 
        // self::setProduct(Newbrick::$data); 
        self::setProduct(Swimmingpool::$data); 
        self::setProduct(Wall::$data); 
        self::setProduct(Wooden::$data); 
        self::setProduct(Basin::$data); 
        self::setProduct(Heater::$data); 
        self::setProduct(Jacuzi::$data); 
        self::setProduct(Shower::$data); 
        self::setProduct(Tap::$data); 
        self::setProduct(Voss::$data); 
        self::setProduct(Wc::$data); 
        self::homeProducts();
    }
}

?>