<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use App\Models\Producttype;
use App\Service\FileService;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ProductController extends Controller
{
     
    public function index(Request $request)
    {
        $producttype_id = $request->producttype_id ?? null;
        $category_id = $request->category_id ?? null;

        $sql = Product::with(["producttype"])->orderBy("producttype_id")
                ->orderBy("home", "desc")->orderBy("active", "desc");
        
        if(!empty($producttype_id))$sql->where("producttype_id", $producttype_id);
        if(!empty($category_id))$sql->where("category_id", $category_id);
        
        $products = $sql->get();
        
        return view("product.index", compact("products"));
    }
 
    public function create()
    {
        $producttypes = producttype::where("active", 1)->get();
        $categories = Category::where("active", 1)->get();
        return view("product.create", compact("producttypes", "categories"));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'category_id' => "required",
            'producttype_id' => "required",
            'name' => "required", 
        ]);

        $request["active"] = 1;
        $request["home"] = $request->home == 1 ? 1 : 0;
        $request["slug"] = Str::slug($request->name).rand(10000, 99999);
        $producttype = producttype::where("id", $request["producttype_id"])->first();
        $request["pic"] = FileService::uploadImage($request->formpic, $producttype->slug);

        Product::create($request->all());
        return redirect()->route("admin.product.create")->with("success", "product created successfully");

    }

    public function show(product $product)
    {
        $producttypes = producttype::where("active", 1)->get();
        return view("product.edit", compact("product", "producttypes"));
    }
     
    
    public function update(Request $request, product $product)
    { 
        $this->validate($request, [
            'name' => "required" 
        ]);
        $request["active"] = $request->active == 1 ? 1 : 0;
        $request["home"] = $request->home == 1 ? 1 : 0;
        $newSlug = Str::slug($request->name);
        if($request->name == $product->name || !Product::where("slug", $newSlug)->exists()){
            $request["slug"] = $newSlug;
        }else{
            $request["slug"] = $newSlug.rand(100000, 999999);
        }
        $arr = $request->only(["name", "slug", "active", "home"]);

        $producttype = producttype::where("id", $request->producttype_id)->first();
        if(!empty($producttype->id))$arr["producttype_id"] = $producttype->id;
        if(!empty($producttype->category_id))$arr["category_id"] = $producttype->category_id;
        if($request->formpic)$request["pic"] = FileService::uploadImage($request->formpic, $producttype->slug);
        
        Product::where("id", $product->id)->update($arr);
        return redirect()->route("admin.product.index") -> with("success", " Product Updated Successfully"); 

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy(product $product)
    {
        
        Product::where("id", $product->id)->delete();
        return redirect()->route("admin.product.index") -> with("success", " Product Was Deleted Successfully");
    }
}
