<?php

namespace App\Http\Controllers;

use App\Models\Management;
use App\Service\FileService;
use Illuminate\Http\Request;

class ManagementController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $managements = Management::all();
        return view("management.index", compact("managements"));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view("management.create");
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => "required",  
        ]);

        $request["active"] = 1; 
        $request["image"] = FileService::uploadImage($request->formfile, "management");
        Management::create($request->all());
        return redirect()->route("admin.management.index")->with("success", "Management Created Successfully");
    }
 
    public function show(management $management)
    {
        return view("management.edit", compact("management"));
    }
 
    public function update(Request $request, management $management)
    {
        $this->validate($request, [
            'name' => "required",  
        ]);

        $request["active"] = $request->active == 1 ? 1 : 0;
        $arr = $request->only(["name", "post", "facebook", "twitter", "instagram", "linkedin", "active"]);

        if(!empty($request->formfile)){
            $arr["image"] = FileService::uploadImage($request->formfile, "management");
        }
        Management::where("id", $management->id)->update($arr);
        return redirect()->route("admin.management.index")->with("success", "Management Updated Successfully");

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\management  $management
     * @return \Illuminate\Http\Response
     */
    public function destroy(management $management)
    {
        //
    }
}
