  @extends("frontend.layout")

  @section("body")
  
  <main class="main">

    <!-- Hero Section -->
    <section id="hero" class="hero section">

      <div class="info d-flex align-items-center">
        <div class="container">
          <div class="row position-relative text-center text-lg-start" data-aos="zoom-in" data-aos-delay="100">
            <div class="col-lg-10">
              <h1>Welcome to <span>Vin-Iyke Multiconnection LTD</span></h1>
              <h2>Delivering Quality Tiles, Doors, Sanitary wares, Profiles and Mirrors of your choice for more than 19 years!</h2>
              <div class="btns">
                {{-- <a href="{{route('allProducts')}}" class="btn-menu animated fadeInUp scrollto">Our Products</a> --}}
                <a href="{{route('gallery')}}" class="btn-book animated fadeInUp scrollto">The Gallery</a>
              </div>
            </div>
            <!-- <div class="col-lg-4 d-flex align-items-center justify-content-center position-relative" data-aos="zoom-in" data-aos-delay="200">
              <a href="https://www.youtube.com/watch?v=u6BOC7CDUTQ" class="glightbox play-btn"></a>
            </div> -->
          </div>
        </div>
      </div>

      <div id="section-fqREP4OWmC-carousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="5000">

        <div class="carousel-item">
          <img src="{{asset('assets/img/tiles/bricks/62403 6 x 24 bricks.jpeg')}}" alt="">
        </div>

        <div class="carousel-item active">
          <img src="{{asset('assets/img/wares/jacuzi/EXECUTIVE STEAM SHOWER (2).jpeg')}}" alt="">
        </div>

        <div class="carousel-item active">
          <img src="{{asset('assets/img/tiles/bricks/SAMPLES ON MIXTURES OF BRICKS.jpeg')}}" alt="">
        </div>

        <div class="carousel-item">
          <img src="{{asset('assets/img/wares/jacuzi/luxury bathtub.jpeg')}}" alt="">
        </div>

        <div class="carousel-item">
          <img src="{{asset('assets/img/doors/STAINLESS DR IN DR 4FT (GOLD).jpeg')}}" alt="">
        </div>

        <div class="carousel-item">
          <img src="{{asset('assets/img/wares/tap/TAPE  (20 ).jpeg')}}" alt="">
        </div>

        <div class="carousel-item">
          <img src="{{asset('assets/img/wares/basin/PASDAL AND WASHING BASIN.jpeg')}}" alt="">
        </div>

        <!-- <a class="carousel-control-prev" href="#section-fqREP4OWmC-carousel" role="button" data-bs-slide="prev">
          <span class="carousel-control-prev-icon bi bi-chevron-left" aria-hidden="true"></span>
        </a>

        <a class="carousel-control-next" href="#section-fqREP4OWmC-carousel" role="button" data-bs-slide="next">
          <span class="carousel-control-next-icon bi bi-chevron-right" aria-hidden="true"></span>
        </a> -->

      </div>

    </section><!-- /Hero Section -->

    <!-- ======= About Section ======= -->
    <section id="about" class="about">
      <div class="container" data-aos="fade-up">

        <div class="row">
          <div class="col-lg-6 order-1 order-lg-2" data-aos="zoom-in" data-aos-delay="100">
            <div class="about-img">
              <img src="{{asset('assets/img/wares/wc/EXECUTIVE GOLD SET OF WC.jpeg')}}" alt="">
            </div>
          </div>
          <div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content">
            <h3>A unique and reputable company that deals on a high quality building and plumbing materials .</h3>
            <p class="fst-italic">
              Our products are unique and the best in the market because we go for the best quality
            </p>
            <ul>
              <li><i class="bi bi-check-circle"></i><strong>Integrity</strong> is our watchword, it shows in our actions.</li>
              <li><i class="bi bi-check-circle"></i><strong>Excellence</strong> -  We prioritize our client needs and strive to exceed their expectation.</li>
              <li><i class="bi bi-check-circle"></i><strong>Quality</strong>- We maintain standard in all aspect to ensure customer satisfaction, we offer luxury at its peak.</li>
              <li><i class="bi bi-check-circle"></i><strong>Fast Delivery</strong>- We deliver quality product swiftly to any location, within Nigeria+.</li>
            </ul>
            <p>
              We deliver a quality brands and categories of Tiles, Doors, Sanitary wares, profiles and Mirror of the best standard.
            </p>
          </div>
        </div>

      </div>
    </section><!-- End About Section -->

    <!-- ======= Why Us Section ======= -->
    <section id="why-us" class="why-us">
      <div class="container" data-aos="fade-up">

        <div class="section-title">
          <h2><b>Why Us</b></h2>
          <p>Why Choose Our Products</p>
        </div>

        <div class="row">

          <div class="col-lg-4">
            <div class="box" data-aos="zoom-in" data-aos-delay="100">
              <span>01</span>
              <h5 class="mt-3"><strong>Product Quality and Variety</strong></h5>
              <p class="mt-3">We deliver and maintain standard in all aspect to ensure customer satisfaction.</p>
            </div>
          </div>

          <div class="col-lg-4 mt-4 mt-lg-0">
            <div class="box" data-aos="zoom-in" data-aos-delay="200">
              <span>02</span>
              <h5 class="mt-3"><b>Fast Delivery</b></h5>
              <p class="mt-3">We deliver quality product swiftly to any location, within Nigeria.</p>
            </div>
          </div>

          <div class="col-lg-4 mt-4 mt-lg-0">
            <div class="box" data-aos="zoom-in" data-aos-delay="300">
              <span>03</span>
              <h5 class="mt-3"><b>Excelence</b></h5>
              <p class="mt-3">We prioritize our client needs and strive to exceed their expectation.</p>
            </div>
          </div>

        </div>

      </div>
    </section><!-- End Why Us Section -->




    <!-- Services Section -->
    <section id="services" class="services section">
 
    <!-- Projects Section -->
    <section id="projects" class="projects section">

      <!-- Section Title -->
      {{-- <div class="container section-title" data-aos="fade-up"> --}}
        <h2 class="">Products</h2>
        <p>Check Our Special Products</p>
      </div><!-- End Section Title -->

      <div class="container">

        <div class="isotope-layout" data-default-filter="*" data-layout="masonry" data-sort="original-order">

          <ul class="portfolio-filters isotope-filters" data-aos="fade-up" data-aos-delay="100">
            <li data-filter="*" class="filter-active">All</li>
            @foreach($categories as $category)
              <li data-filter=".{{$category->slug}}">{{$category->name}}</li>
            @endforeach 
          </ul><!-- End Portfolio Filters -->

          <div class="row gy-4 isotope-container" data-aos="fade-up" data-aos-delay="200">

            @foreach($products as $product) 
              <div class="col-lg-4 col-md-6 portfolio-item isotope-item {{$product->category->slug}}">
                <div class="portfolio-content h-100">
                  <img src="{{asset($product->pic)}}" class="img-fluid" alt="">
                  <div class="portfolio-info">
                    <h4>{{$product->name}}</h4>
                    <p>{{$product->name}}</p>
                    <a href="{{asset($product->pic)}}" title="{{$product->name}}" data-gallery="portfolio-gallery-tiles" class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                    <a href="{{route('get.product', $product->category->slug)}}?id={{$product->id
                      }}" title="More Details" class="details-link"><i class="bi bi-link-45deg"></i></a>
                  </div>
                </div>
              </div><!-- End Portfolio Item -->
            @endforeach 
          </div><!-- End Portfolio Container -->

        </div>

      </div>

    </section><!-- /Projects Section -->


    <!-- ======= Managemet Team ======= -->
    <section id="chefs" class="chefs">
      <div class="container" data-aos="fade-up">

        <div class="section-title">
          <h2>Management</h2>
          <p>Our Management Team</p>
        </div>

        <div class="row">
          @foreach ($managements as $management)              
            <div class="col-lg-4 col-md-6">
              <div class="member" data-aos="zoom-in" data-aos-delay="100">
                <img src="{{asset($management->image)}}" class="img-fluid" alt="">
                <div class="member-info">
                  <div class="member-info-content">
                    <h4>{{$management->name}}</h4>
                    <span>{{$management->post}}</span>
                  </div>
                  <div class="social">
                    @if($management->twitter && strlen($management->twitter) > 0)
                      <a href="{{$management->twitter ?? "#"}}"><i class="bi bi-twitter"></i></a>
                    @endif
                    @if($management->facebook && strlen($management->facebook) > 0)
                      <a href="{{$management->facebook ?? "#"}}"><i class="bi bi-facebook"></i></a>
                    @endif
                    @if($management->instagram && strlen($management->instagram) > 0)
                      <a href="{{$management->instagram ?? "#"}}"><i class="bi bi-instagram"></i></a>
                    @endif
                    @if($management->linkedin && strlen($management->linkedin) > 0)
                      <a href="{{$management->linkedin ?? "#"}}"><i class="bi bi-linkedin"></i></a>
                    @endif
                  </div>
                </div>
              </div>
            </div>
          @endforeach
        </div>

      </div>
    </section><!-- End Chefs Section -->


    <!-- Galary  -->
    <section id="services" class="services section">

      <!-- Section Title -->
      <div class="container section-title" data-aos="fade-up">
        <h2>Gallery</h2>
        <p>Some of our Quality Products</p>
      </div><!-- End Section Title -->

      <div class="container">

        <div class="row gy-4">

          @foreach($galleries as $gallery) 
            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
              <div class="service-item  position-relative"> 
                <h3>{{$gallery->name}}</h3>
                <img src="{{asset($gallery->pic)}}" style="height:300px !important" class="img-fluid" alt="">
                <p></p>                
                <a href="{{route('get.product', $gallery->slug)}}" class="readmore stretched-link">view more <i class="bi bi-arrow-right"></i></a>
              </div>
            </div>
          @endforeach 
        </div>

      </div>

    </section><!-- /Services Section -->
  

  </main>
